/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.plate;

import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabRedstone;
import cofh.core.gui.element.TabSecurity;
import cofh.core.render.IconRegistry;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementFluid;
import cofh.lib.gui.element.ElementIcon;
import cofh.lib.gui.element.ElementSimpleToolTip;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.thermalexpansion.block.plate.TilePlateTranslocate;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalfoundation.fluid.TFFluids;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiPlateTranslocate
extends GuiBaseAdv {
    static final String TEX_PATH = "thermalexpansion:textures/gui/plate/Plate.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/plate/Plate.png");
    TilePlateTranslocate myTile;
    UUID playerName;
    ElementButton decDistance;
    ElementButton incDistance;
    ElementIcon plateTop;

    public GuiPlateTranslocate(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super((Container)new ContainerTEBase(inventoryPlayer, tileEntity, false, false), TEXTURE);
        this.myTile = (TilePlateTranslocate)tileEntity;
        ((GuiBase)this).name = this.myTile.func_145825_b();
        this.playerName = SecurityHelper.getID((EntityPlayer)inventoryPlayer.field_70458_d);
        ((GuiBase)this).drawInventory = false;
        ((GuiContainer)this).field_147000_g = 100;
        this.generateInfo("tab.thermalexpansion.plate.translocate", 2);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        this.addTab((TabBase)new TabRedstone((GuiBase)this, (IRedstoneControl)this.myTile));
        if (this.myTile.enableSecurity() && this.myTile.isSecured()) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)this.myTile, this.playerName));
        }
        this.addElement(new ElementSimpleToolTip((GuiBase)this, 13, 24).setToolTip("info.cofh.distance").setSize(24, 24).setTexture("cofh:textures/gui/elements/Info_Distance.png", 32, 32));
        this.addElement(new ElementFluid((GuiBase)this, 134, 32).setFluid(TFFluids.fluidEnder).setSize(16, 16));
        this.decDistance = new ElementButton((GuiBase)this, 10, 66, "decDistance", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incDistance = new ElementButton((GuiBase)this, 26, 66, "incDistance", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.decDistance);
        this.addElement((ElementBase)this.incDistance);
        this.plateTop = new ElementIcon((GuiBase)this, 134, 32, IconRegistry.getIcon((String)"PlateTop", (int)this.myTile.getFacing()));
        this.addElement((ElementBase)this.plateTop);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.myTile.canAccess()) {
            ((GuiScreen)this).field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void handleElementButtonClick(String string, int n) {
        byte by = 1;
        float f = 0.7f;
        byte by2 = this.myTile.distance;
        if (string.equalsIgnoreCase("decDistance")) {
            this.myTile.distance = (byte)(this.myTile.distance - by);
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("incDistance")) {
            this.myTile.distance = (byte)(this.myTile.distance + by);
            f += 0.1f;
        }
        GuiPlateTranslocate.playSound((String)"random.click", (float)1.0f, (float)f);
        this.myTile.sendModePacket();
        this.myTile.distance = by2;
    }

    protected void updateElementInformation() {
        if (this.myTile.distance > 0) {
            this.decDistance.setActive();
        } else {
            this.decDistance.setDisabled();
        }
        if (this.myTile.distance < 16) {
            this.incDistance.setActive();
        } else {
            this.incDistance.setDisabled();
        }
        this.plateTop.setIcon(IconRegistry.getIcon((String)"PlateTop", (int)this.myTile.getFacing()));
    }

    protected void func_146979_b(int n, int n2) {
        int n3 = 26;
        String string = String.format("%-8s", "" + this.myTile.distance);
        if (this.myTile.distance < 10) {
            n3 += 6;
        }
        ((GuiScreen)this).field_146289_q.func_78276_b(string, n3, 56, 0x404040);
        super.func_146979_b(n, n2);
    }

    protected void func_73864_a(int n, int n2, int n3) {
        if (134 <= ((GuiBase)this).mouseX && ((GuiBase)this).mouseX < 150 && 32 <= ((GuiBase)this).mouseY && ((GuiBase)this).mouseY < 48) {
            int n4 = this.myTile.getFacing();
            float f = 0.7f;
            if (n3 == 1) {
                n4 += 5;
                f -= 0.1f;
            } else {
                ++n4;
                f += 0.1f;
            }
            if (this.myTile.setFacing(n4 %= 6)) {
                GuiPlateTranslocate.playSound((String)"random.click", (float)1.0f, (float)f);
                this.myTile.sendModePacket();
            }
        } else {
            super.func_73864_a(n, n2, n3);
        }
    }
}

