/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.core.BiomesOPlenty;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ModConfig {
    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path bopConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "biomesoplenty");
        try {
            Files.createDirectory(bopConfigPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            BiomesOPlenty.logger.error("Failed to create biomesoplenty config directory", (Throwable)e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ServerConfig.SPEC, "biomesoplenty/server.toml");
    }

    public static class ServerConfig {
        public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        public static final ForgeConfigSpec SPEC;
        public static final ForgeConfigSpec.BooleanValue useWorldType;

        static {
            BUILDER.comment("Server-related options. Please ignore this file if you are not running a server.");
            BUILDER.push("biomes");
            useWorldType = BUILDER.comment("Use the Biomes O' Plenty world type on a dedicated server.").define("use_world_type", true);
            BUILDER.pop();
            SPEC = BUILDER.build();
        }
    }
}

