/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;

public class PoplarTreeFeature
extends TreeFeatureBase {
    protected PoplarTreeFeature(boolean notify, IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight) {
        super(notify, placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
    }

    @Override
    protected boolean place(Set<BlockPos> changedBlocks, IWorld world, Random random, BlockPos startPos, MutableBoundingBox boundingBox) {
        int i;
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        if (height < 4) {
            return false;
        }
        int baseHeight = height / 3;
        int leavesHeight = height - baseHeight;
        BlockPos pos = startPos.func_177984_a();
        if (!this.checkSpace(world, pos, baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.setLog(changedBlocks, world, pos, boundingBox);
            pos = pos.func_177984_a();
        }
        for (i = 1; i < leavesHeight - 3; ++i) {
            for (int xx = -1; xx < 2; ++xx) {
                for (int zz = -1; zz < 2; ++zz) {
                    this.setLeaves(world, pos.func_177982_a(xx, i, zz));
                }
            }
        }
        for (i = 0; i < leavesHeight; ++i) {
            int radius = this.radius(i, leavesHeight);
            this.generateLeafLayer(world, pos, radius);
            if (leavesHeight - i > 2) {
                this.setLog(changedBlocks, world, pos, boundingBox);
            }
            pos = pos.func_177984_a();
        }
        return true;
    }

    public int radius(int height, int maxHeight) {
        float x = (float)height / (float)maxHeight;
        float maxRadius = 1.0f + (float)maxHeight * 0.1f;
        float r = maxRadius * 0.6667f * x * (1.0f / (x * x + 0.08173f) - 0.9244f);
        return (int)(r + 0.5f);
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(IWorld world, BlockPos pos, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (radius < 2) {
                    if (x * x + z * z > radius * radius) continue;
                    this.setLeaves(world, pos.func_177982_a(x, 0, z));
                    continue;
                }
                if ((x == -radius || x == radius) && (z == -radius || z == radius)) continue;
                if (x == -radius || x == radius || z == -radius || z == radius) {
                    if (world.func_201674_k().nextInt(3) == 0) continue;
                    this.setLeaves(world, pos.func_177982_a(x, 0, z));
                    continue;
                }
                this.setLeaves(world, pos.func_177982_a(x, 0, z));
            }
        }
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, PoplarTreeFeature> {
        public Builder() {
            this.minHeight = 12;
            this.maxHeight = 15;
        }

        @Override
        public PoplarTreeFeature create() {
            return new PoplarTreeFeature(this.updateNeighbours, this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight);
        }
    }
}

