/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.BitSet;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.FireWallFlag;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.resources.IResource;
import logisticspipes.textures.Textures;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public class PipeItemsFirewall
extends CoreRoutedPipe {
    public ItemIdentifierInventory inv = new ItemIdentifierInventory(36, "Filter Inv", 1);
    private boolean blockProvider = false;
    private boolean blockCrafer = false;
    private boolean blockSorting = false;
    private boolean blockPower = true;
    private boolean isBlocking = true;
    private IFilter filter = null;

    public PipeItemsFirewall(Item item) {
        super(item);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 17, this.getWorld(), this.getX(), this.getY(), this.getZ());
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FireWallFlag.class).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), entityplayer);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("blockProvider", this.blockProvider);
        nbttagcompound.func_74757_a("blockCrafer", this.blockCrafer);
        nbttagcompound.func_74757_a("blockSorting", this.blockSorting);
        nbttagcompound.func_74757_a("blockPower", this.blockPower);
        nbttagcompound.func_74757_a("isBlocking", this.isBlocking);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
        this.blockProvider = nbttagcompound.func_74767_n("blockProvider");
        this.blockCrafer = nbttagcompound.func_74767_n("blockCrafer");
        this.blockSorting = nbttagcompound.func_74767_n("blockSorting");
        if (nbttagcompound.func_74764_b("blockPower")) {
            this.blockPower = nbttagcompound.func_74767_n("blockPower");
        }
        this.isBlocking = nbttagcompound.func_74767_n("isBlocking");
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_FIREWALL_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public IFilter getFilter() {
        if (this.filter == null) {
            this.filter = new IFilter(){

                @Override
                public boolean isBlocked() {
                    return PipeItemsFirewall.this.isBlocking;
                }

                @Override
                public boolean isFilteredItem(ItemIdentifier item) {
                    return PipeItemsFirewall.this.inv.containsUndamagedExcludeNBTItem(item.getIgnoringNBT().getUndamaged());
                }

                @Override
                public boolean blockProvider() {
                    return PipeItemsFirewall.this.blockProvider;
                }

                @Override
                public boolean blockCrafting() {
                    return PipeItemsFirewall.this.blockCrafer;
                }

                @Override
                public boolean blockRouting() {
                    return PipeItemsFirewall.this.blockSorting;
                }

                @Override
                public boolean blockPower() {
                    return PipeItemsFirewall.this.blockPower;
                }

                public int hashCode() {
                    return PipeItemsFirewall.this.hashCode();
                }

                public String toString() {
                    return super.toString() + " (" + PipeItemsFirewall.this.getX() + ", " + PipeItemsFirewall.this.getY() + ", " + PipeItemsFirewall.this.getZ() + ")";
                }

                @Override
                public LPPosition getLPPosition() {
                    return PipeItemsFirewall.this.getLPPosition();
                }

                @Override
                public boolean isFilteredItem(IResource resultItem) {
                    for (Pair<ItemIdentifierStack, Integer> pair : PipeItemsFirewall.this.inv) {
                        ItemIdentifierStack stack = pair.getValue1();
                        if (stack == null || !resultItem.matches(stack.getItem(), IResource.MatchSettings.NORMAL)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.filter;
    }

    public boolean isBlockProvider() {
        return this.blockProvider;
    }

    public void setBlockProvider(boolean blockProvider) {
        this.blockProvider = blockProvider;
        MainProxy.sendPacketToServer(PacketHandler.getPacket(FireWallFlag.class).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    public boolean isBlockCrafer() {
        return this.blockCrafer;
    }

    public void setBlockCrafer(boolean blockCrafer) {
        this.blockCrafer = blockCrafer;
        MainProxy.sendPacketToServer(PacketHandler.getPacket(FireWallFlag.class).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    public boolean isBlockSorting() {
        return this.blockSorting;
    }

    public void setBlockSorting(boolean blockSorting) {
        this.blockSorting = blockSorting;
        MainProxy.sendPacketToServer(PacketHandler.getPacket(FireWallFlag.class).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    public boolean isBlockPower() {
        return this.blockPower;
    }

    public void setBlockPower(boolean blockPower) {
        this.blockPower = blockPower;
        MainProxy.sendPacketToServer(PacketHandler.getPacket(FireWallFlag.class).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
        MainProxy.sendPacketToServer(PacketHandler.getPacket(FireWallFlag.class).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    private BitSet getFlags() {
        BitSet flags = new BitSet();
        flags.set(0, this.blockProvider);
        flags.set(1, this.blockCrafer);
        flags.set(2, this.blockSorting);
        flags.set(3, this.blockPower);
        flags.set(4, this.isBlocking);
        return flags;
    }

    public void setFlags(BitSet flags) {
        this.blockProvider = flags.get(0);
        this.blockCrafer = flags.get(1);
        this.blockSorting = flags.get(2);
        this.blockPower = flags.get(3);
        this.isBlocking = flags.get(4);
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }
}

